package gov.va.vinci.dart.db.impl;

import java.util.List;

import gov.va.vinci.dart.biz.ResearchStudy;
import gov.va.vinci.dart.db.ResearchStudyDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

import javax.persistence.Query;

public class ResearchStudyDAOImpl extends HibernateDAO implements ResearchStudyDAO {

	@Override
	public void save(final ResearchStudy researchStudy) {
		if (researchStudy == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(researchStudy);
	}
	
	@Override
	public ResearchStudy findById(final int activityId) {
		Query q = createQuery("from ResearchStudy where id=:aid");
		q.setParameter("aid", activityId);
		return (ResearchStudy)q.getSingleResult();
	}

	@Override
	public ResearchStudy findByShortName(final String name) {
		
		Query query = createQuery("from ResearchStudy where name like :rsid");
		query.setParameter("rsid", name);
		return (ResearchStudy)query.getSingleResult();
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<ResearchStudy> listAll() {
		Query query = createQuery("from ResearchStudy");
		return (List<ResearchStudy>)query.getResultList();
	}
}
